﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Admin/Ei8htPOS.Master" AutoEventWireup="true" CodeBehind="TopCustomersByOrdersReport.aspx.cs" Inherits="AZVIC.Ei8htPOS.WebUI.Admin.Reports.TopCustomersByOrdersReport" %>
<%@ MasterType VirtualPath="~/Admin/Ei8htPOS.Master" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <div class="pageheader">
        <h2>
            <i class="fa fa-user"></i> Top 20 Customers By Number of Orders
        </h2>
        <div class="breadcrumbs">
            <ol class="breadcrumb">
                <li>You are here</li>
                <li><a href="dashboard.aspx">Ei8ht POS</a></li>
                <li><a href="Reports.aspx">Reports</a></li>
                <li class="active">Customers</li>
            </ol>
        </div>
    </div>
    <div class="main searchFields">
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite">
                From Date :

            </div>
            <div class="col-md-4 col-xs-12">
                <asp:TextBox ID="txtFromDate" runat="server" CssClass="datepicker" />

            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite">To Date :</div>
            <div class="col-md-4 col-xs-12">
                <asp:TextBox ID="txtToDate" runat="server" CssClass="datepicker" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite"></div>
            <div class="col-md-4 col-xs-12">
                <asp:Button ID="btnSearch" runat="server" CssClass="btn-lg btn btn-primary loading" Text="Search"
                    OnClick="btnSearch_Click" />
                &nbsp;&nbsp;&nbsp;
                        <asp:Button ID="btnShowAll" runat="server" CssClass="btn-lg btn btn-primary loading" Text="Show All"
                            OnClick="btnShowAll_Click" />
            </div>
        </div>
    </div>

    <div class="main searchFields">
    <div class="row">
        <div class="col-md-6 col-xs-12">
            
            <div class="morris-chart" id="TopCustomerReport"></div><br />
            <h4 class="cwhite"> Top 5 Customers - Customers Vs Number of Orders</h4>
        </div>
    </div>
    </div>

    <section class="tile contentField color">
        <div class="tile-header">
            <h1>Top 20 Customers</h1><div class="pull-right">
                <asp:Button runat="server" ID="btnExport" OnClick="btnExportToExcel" CssClass="btn-lg btn btn-primary" Text="Export" />
            </div>
        </div>
        <div class="tile-body nopadding">

            <div class="responsive-table">
                <asp:GridView runat="server" ID="grdCustomers" AllowPaging="true" PageSize="25"
            CssClass="table" Width="98%" GridLines="Both" AutoGenerateColumns="false"
            OnPageIndexChanging="grdCustomers_PageIndexChanging">
            <Columns>
                <asp:TemplateField HeaderStyle-Width="20" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                    HeaderText="Sl. No.">
                    <ItemTemplate>
                        <%# Container.DataItemIndex + 1  %>
                    </ItemTemplate>
                    <HeaderStyle HorizontalAlign="Center" Width="100px"></HeaderStyle>
                    <ItemStyle HorizontalAlign="Center"></ItemStyle>
                </asp:TemplateField>
                <asp:BoundField HeaderText="Name" DataField="BillingName" />
                <asp:BoundField HeaderText="Email" DataField="Email" />
                <asp:BoundField HeaderText="Total Sales" DataField="TotalOrders" />
            </Columns>
            <PagerSettings Mode="NumericFirstLast" Visible="true" NextPageText="" PreviousPageText=""
                Position="TopAndBottom" />
          <PagerStyle CssClass="pg" HorizontalAlign="Right" VerticalAlign="Middle" BorderStyle="None"
                        Font-Bold="true" Font-Size="Medium" />
            <HeaderStyle CssClass="tbl-header" />
            <RowStyle CssClass="tbl-row" />
            <AlternatingRowStyle CssClass="tbl-row" />
            <EmptyDataRowStyle />
            <EmptyDataTemplate>
                No Record found
            </EmptyDataTemplate>
            <EmptyDataRowStyle VerticalAlign="Middle" HorizontalAlign="Center" />
        </asp:GridView>
                </div>
            </div>

          </section>
    <div class="row Footercenter">
        <center>All right reserved - www.ei8htpos.com &copy; 2015</center>
    </div>

</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ScriptContent" runat="server">
    <script>
        function DrawChart() {
            Morris.Bar({
                element: 'TopCustomerReport',
                data: [
                    <% for (int i = 0; (topCustomer!=null && i < topCustomer.Rows.Count && i < 5); i++)
                       { %>
                    <%= "{ label: '"%><%= topCustomer.Rows[i]["BillingName"].ToString()%><%="', value:"%><%=topCustomer.Rows[i]["TotalOrders"].ToString()+ " }" %>
                   <% if (i != topCustomer.Rows.Count - 1) {%>
                    <%=","%>
                    <% }
                       } %>
                ],
                xkey: 'label',
                ykeys: ['value'],
                labels: ['Number of Orders by Customer']
            });
        }
        $(document).ready(function () { DrawChart(); });
        $(window).resize(function () { $('#TopCustomerReport').children().remove();DrawChart(); });

    </script>
</asp:Content>
